/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Trie;

public class TrieTest
extends TestCase {
    protected String[] m_Data;
    protected Trie m_Trie;

    public TrieTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Data = new String[]{"this is a test", "this is another test", "and something else"};
        this.m_Trie = this.buildTrie(this.m_Data);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public Trie buildTrie(String data) {
        return this.buildTrie(new String[]{data});
    }

    public Trie buildTrie(String[] data) {
        Trie result = new Trie();
        int i = 0;
        while (i < data.length) {
            result.add(data[i]);
            ++i;
        }
        return result;
    }

    public void testCorrectBuild() {
        Iterator<String> iter = this.m_Trie.iterator();
        HashSet<String> set = new HashSet<String>();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        TrieTest.assertEquals("size() does not reflect number of added strings", this.m_Data.length, this.m_Trie.size());
        TrieTest.assertEquals("Iterator returns different number of strings", this.m_Data.length, set.size());
        int i = 0;
        while (i < this.m_Data.length) {
            if (!set.contains(this.m_Data[i])) {
                TrieTest.fail("Cannot find string '" + this.m_Data[i] + "'");
            }
            ++i;
        }
    }

    public void testDifferentBuildOrder() {
        String[] newData = new String[this.m_Data.length];
        int i = 0;
        while (i < this.m_Data.length) {
            newData[i] = this.m_Data[this.m_Data.length - i - 1];
            ++i;
        }
        Trie t2 = this.buildTrie(this.m_Data);
        if (!this.m_Trie.equals(t2)) {
            TrieTest.fail("Tries differ");
        }
    }

    public void testClone() {
        Trie clone = (Trie)this.m_Trie.clone();
        if (!this.m_Trie.equals(clone)) {
            TrieTest.fail("Tries differ");
        }
    }

    public void testRemoveAllPartial() {
        Trie remove = this.buildTrie(this.m_Data[0]);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.removeAll(remove);
        TrieTest.assertEquals("Removing of 1 string", clone.size(), this.m_Trie.size() + 1);
    }

    public void testRemoveAllFull() {
        Trie remove = this.buildTrie(this.m_Data);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.removeAll(remove);
        TrieTest.assertEquals("Removing all strings", clone.size(), this.m_Trie.size() + this.m_Data.length);
    }

    public void testRetainAllPartial() {
        Trie retain = this.buildTrie(this.m_Data[0]);
        this.m_Trie.retainAll(retain);
        TrieTest.assertEquals("Retaining of 1 string", 1, this.m_Trie.size());
    }

    public void testRetainAllFull() {
        Trie retain = this.buildTrie(this.m_Data);
        Trie clone = (Trie)this.m_Trie.clone();
        this.m_Trie.retainAll(retain);
        TrieTest.assertEquals("Retaining all strings", clone.size(), this.m_Trie.size());
    }

    public void testCommonPrefix() {
        String returned = this.m_Trie.getCommonPrefix();
        TrieTest.assertEquals("Common prefixes differ", 0, returned.length());
        String expected = "this is a";
        Trie t = this.buildTrie(new String[]{this.m_Data[0], this.m_Data[1]});
        returned = t.getCommonPrefix();
        TrieTest.assertEquals("Common prefixes differ", expected.length(), returned.length());
    }

    public void testFindPrefixes() {
        Vector<String> prefixes = this.m_Trie.getWithPrefix("this");
        TrieTest.assertEquals("Different number of prefixes returned", 2, prefixes.size());
        prefixes = this.m_Trie.getWithPrefix("blah");
        TrieTest.assertEquals("Different number of prefixes returned", 0, prefixes.size());
    }

    public static Test suite() {
        return new TestSuite(TrieTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(TrieTest.suite());
    }
}

